--this has a function for creating emitter bullets
require('g_level')

function create_poison_bullet(path_list,is_repeating,speed,layer) --list of path points, is_repeating
    local bullet_sound_radius = 50.0
    local bullet_sound = "data/music/effect_stereo.ogg"
    local bullet_speed = speed
    local dmg_start_script = "data/scripts/test/srt_start_damage_test.lua"
    local dmg_end_script = "data/scripts/test/srt_stop_damage_test.lua"
    local bullet_trigger_radius = 30.0
    
    
    local from_x = path_list[1][1]
    local from_y = path_list[1][2]
    local bullet_id = g_level.give_id()
    --bullet starts
    lua:create_bullet( "bullet", bullet_id )            -- shooter id, bullet id -- lets just create bullet to our shooter, little stupid but anyway
    --bullet trigger
    lua:create_circle( "bullet_shape", 0, 0, bullet_trigger_radius)         --shape with, 1 = shape with number of verticies, 5 = number of verticies

    lua:create_trigger( "bullet_trigger", TT_GATE, dmg_start_script,dmg_end_script, from_x,from_y)  --name, type, on_enter_script, on_leave_scipt,x,y  -- x and y should be very close to real start location
    lua:trigger_shape(  "bullet_trigger", TT_GATE, "bullet_shape")                --name, type, shape_name
    lua:trigger_add_group_i_belong_to( "bullet_trigger", TT_GATE, "everything") --name, type, group_name
    lua:trigger_add_group_can_use_me(  "bullet_trigger", TT_GATE, "player")     --name, type, group_name

    lua:trigger_set_color(  "bullet_trigger", 1.0, 0.0, 0.0, 0.5);              --trigger name, red, green, blue, alpha
    lua:bullet_set_trigger( "bullet", "bullet_trigger" );                       --shooter id, trigger name

    --Bullet graphics
    lua:create_sprite("drop1", ST_TEXTURED,"drop", from_x , from_y) -- nimi, joku, tekstuurin nimi, x, y
    lua:sprite_color("drop1", 1.0, 1.0, 1.0 , 1.0)
    lua:sprite_shape("drop1",ST_TEXTURED, 16, 16)
    lua:textured_sprite_tex_coords("drop1", ST_TEXTURED, 0.0, 0.0, 1.0, 1.0)

    lua:remorfable_sprite("bullet_sprite", "drop1", bullet_speed, is_repeating)             -- name, sprite_name, speed, repeat
    
    for i=1, #path_list ,1  do
        local tmp_list = path_list[i]
        lua:add_key_frame(tmp_list[3], tmp_list[1], tmp_list[2], 0.0, 1.0)  -- adds a new key frame. time, x, y, rotation, scale
        lua:add_key_frame_color(1.0,1.0,1.0,1.0)  -- r,g,b,a
        lua:upload_key_frame("bullet_sprite")
    end

    --Bullet Graphics end
    lua:bullet_set_graphics("bullet", "bullet_sprite") -- shooter id, sprite
    lua:gameobject_remove_from_temp_list( "bullet_sprite" )

    --Bullet audio
    lua:create_sound("bullet_flying_sound", bullet_sound, bullet_sound_radius, from_x, from_y)  -- name, music_name, radius ( x and y will be replaced at first update  but good to have real place )
    lua:create_sound_effect("bullet_flying_sound", "bullet_flying_sound", 0.1, true)            -- object name, sound name, delay, loop
    lua:bullet_set_flying_sound("bullet", "bullet_flying_sound")                              -- shooter id, flying sound
    lua:gameobject_remove_from_temp_list( "bullet_flying_sound" )
    --bullet ends
    
    g_level.upload("bullet",layer)
end

--LOAD GRAPHICS
lua_init_texture("drop", "data/images/sewer/drop.png",FM_NEAREST,WM_REPEAT,WM_CLAMP,AM_MODULATE)